IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_PROD_IMP_CODIGO_BARRAS')
BEGIN
	DROP TRIGGER TRG_EST_PROD_IMP_CODIGO_BARRAS
END
GO
CREATE TRIGGER [dbo].[TRG_EST_PROD_IMP_CODIGO_BARRAS] ON [dbo].[EST_PROD_IMP] FOR UPDATE AS
IF UPDATE(QT_IMP)
begin
	IF EXISTS(SELECT 
					CD_PROD
				FROM 
					INSERTED
			    WHERE 
					QT_IMP>999999)
	  begin
		RAISERROR ('Produto com a quantidade de estoque fora do padrao, pela analise esta sendo atualizado com numeros de codigos de barras.',16, 1); 
		RETURN;
	  end
end

GO

ALTER TABLE [dbo].[EST_PROD_IMP] ENABLE TRIGGER [TRG_EST_PROD_IMP_CODIGO_BARRAS]
GO


